/*
  ifilter.h -- input filter functions for CONSERV

    Copyright (C) 1999,2000 Naohisa Goto <ngoto@gen-info.osaka-u.ac.jp>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef IFILTER_H
#define IFILTER_H

/* string length NOT include last '\0' */

#ifndef TYPEDEF_UCHAR
#define TYPEDEF_UCHAR
typedef unsigned char uchar;
#endif /* TYPEDEF_UCHAR */

#define IFILTER_NORMAL 0
#define IFILTER_OVERRIDE 1

struct ifilter_details {
  void *(*open)(uchar *, uchar **);
  void (*close)(void *);
  int (*main)(uchar *, int, void *);
  void (*help)(const uchar *, FILE *);
};

struct ifilter_namelist {
  const uchar *name;
  const struct ifilter_details *details;
  const int attribute;
  struct ifilter_namelist *next;
};

struct ifilter_activelist {
  struct ifilter_activelist *next;
  struct ifilter_activelist *before;
  struct ifilter_namelist *namelist;
  void *settings;
  uchar *optstr;
};

struct ifilter_result {
  uchar *str;
  int len;
  int offset;
  int offset_c;
  struct ifilter_result *next;
};

void ifilter_print_help(struct ifilter_namelist *nlist, FILE *fpo);
void ifilter_print_activelist(struct ifilter_activelist *alist,
 FILE *fpo, uchar *prefix);
void ifilter_result_free(struct ifilter_result *ifr);
struct ifilter_result *ifilter_main(uchar *str_in, int len_in,
 struct ifilter_activelist *alist);
struct ifilter_activelist *ifilter_registration(uchar *optarg,
 struct ifilter_namelist *namelist, struct ifilter_activelist *alist);
void ifilter_close_all(struct ifilter_activelist *alist);

/* global variables */
#define IFILTER_NAMELIST_LISTALL NULL

#endif /* IFILTER_H */

