/*
  mfstlib3.h -- reading Multi-FASTA formatted sequences

    Copyright (C) 1999 Naohisa Goto <ngoto@gen-info.osaka-u.ac.jp>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* mfstlib3.h (with mfstlib3.c) 19990806 */
#ifndef MFSTLIB_H

/* memory size = MEM_CHAINS * MEM_BLOCKSIZE */

#define TABLESIZE 256
/* convert flag */
#define CONVERT_NOTHING 0

#define CMASK_111 7
#define CONVERT_COMPLEMENT_DNA 1
#define CONVERT_COMPLEMENT_RNA 2
#define CONVERT_DNA 3
#define CONVERT_RNA 4

#define CMASK_11000 24
#define CONVERT_TOUPPER 8
#define CONVERT_TOLOWER 16

/* for compatible and convenience */
#define COMPLEMENT_DNA (CONVERT_COMPLEMENT_DNA)
#define COMPLEMENT_RNA (CONVERT_COMPLEMENT_RNA)

/* output flag */
#define FLAG_NORET 1

struct Sequence {
  int magic;
  int namelen;
  int seqlen;
  unsigned char *name;
  unsigned char *seq;
};

typedef struct Sequence SEQUENCE;

int seq_garbage_collection(void);
#define garbage_collection() (seq_garbage_collection())

int get_fasta(SEQUENCE *p, FILE *infile);
SEQUENCE *seq_open(void);
void seq_init(SEQUENCE *p);
int seq_close(SEQUENCE *p);

int seq_duplicate(SEQUENCE *src, SEQUENCE *dst);
int seq_resize_seq(SEQUENCE *s, int newsize);
int seq_resize_name(SEQUENCE *s, int newsize);

int seq_getsize(SEQUENCE *p);
#define seq_getsize(p) ((p)->seqlen)

int seq_getnamelen(SEQUENCE *p);
#define seq_getnamelen(p) ((p)->namelen)

unsigned char *seq_getname(SEQUENCE *p);
#define seq_getname(p) ((p)->name)

unsigned char *seq_getseq(SEQUENCE *p);
#define seq_getseq(p) ((p)->seq)

int seq_getchar(SEQUENCE *p, int pos);
/* pos begins with 0 */
#define seq_getchar(p, pos) (*((p)->seq + (pos)))

int set_output(FILE *fp);
int set_width(int width);

int out_seq_putc(int c);

int *get_convert_table(int type);
int seq_convertall(SEQUENCE *p, int *table);
int seq_convertall_reverse(SEQUENCE *s, int *table);

int print_seq(SEQUENCE *p, FILE *fpo, long st, long ed,
 int rev, int flags_out);
int print_seq_c(SEQUENCE *p, FILE *fpo, long st, long ed,
 int rev, int flags_out, int *table);

int seq_count_content(SEQUENCE *p, int *table, unsigned char *cstr);

#define MFSTLIB_H
#endif /* MFSTLIB_H */

