/*
  case_ifilter.c -- input filter: changing case

    Copyright (C) 1999,2000 Naohisa Goto <ngoto@gen-info.osaka-u.ac.jp>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* xmask_ifilter.c */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <unistd.h>
#include <stddef.h>
#include "my_malloc.h"
#include "ifilter.h"
#include "case_ifilter.h"

/* string length NOT include last '\0' */
static void case_ifilter_help(const uchar *name, FILE *fpo);
static void *case_ifilter_open(uchar *optarg, uchar **optstr_new);
static void case_ifilter_close(void *settings);
static int case_ifilter_main(uchar *str_in, int len_in, void *settings);

/* global variables */
const struct ifilter_details case_ifilter_details = {
  case_ifilter_open,
  case_ifilter_close,
  case_ifilter_main,
  case_ifilter_help
};

static void case_ifilter_help(const uchar *name, FILE *fpo)
{
  fprintf(fpo, "    case: convert case (uppercase or lowercase)\n");
  fprintf(fpo, "        case={upper|lower|-}\n"
	       "            upper       uppercase\n"
	       "            lower       lowercase\n"
	       "            -           not convert (disable this filter)\n"
	);
  return;
} /* end of func */

static int func_toupper(int c)
{
  return toupper(c);
} /* end of func */

static int func_tolower(int c)
{
  return tolower(c);
} /* end of func */

static int func_through(int c)
{
  return c;
} /* end of func */

struct case_ifilter_options {
  uchar *str;
  int (*action)(int);
};

static struct case_ifilter_options optstrings[] = {
  { "upper", func_toupper },
  { "lower", func_tolower },
  { "-", func_through },
  { NULL, NULL }
};

static void *case_ifilter_open(uchar *optarg, uchar **optstr_new)
{
  struct case_ifilter_options *p = optstrings;
  uchar *s;
  int slen;

  while (p->str != NULL) {
    if (strcmp(optarg, p->str) == 0) {
      slen = strlen(p->str) + 1;
      s = my_malloc(slen);
      strncpy(s, p->str, slen);
      *optstr_new = s;
      return (void *)p->action;
    }
    p++;
  } /* while */

  fprintf(stderr, "error: case filter: unknown option %s\n", optarg);
  return NULL;
} /* end of func */

static void case_ifilter_close(void *settings)
{
  return;
} /* end of func */

static int case_ifilter_main(uchar *str_in, int len_in, void *settings)
{
  int i, c;
  int (*action)(int);

  action = (int (*)(int))settings;
  for (i = 0; i < len_in; i++) {
    c = *str_in;
    *str_in++ = action(c);
  }

  return 0;
} /* end of func */

