/*
  my_malloc.c -- malloc wrapper

    Copyright (C) 1999,2000 Naohisa Goto <ngoto@gen-info.osaka-u.ac.jp>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define _REENTRANT

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <unistd.h>
#include "my_malloc.h"

void my_free(void *ptr)
{
  free(ptr);
} /* end of func */

void *my_malloc(size_t size)
{
  void *p;

  p = malloc(size);
  if (p == NULL) {
    fprintf(stderr, "Memory allocate error; fatal, aborted.\n");
    exit(2);
  }

  return p;
} /* end of func */

void *my_calloc(size_t nelem, size_t elsize)
{
  void *p;

  p = calloc(nelem, elsize);
  if (p == NULL) {
    fprintf(stderr, "Memory allocate error; fatal, aborted.\n");
    exit(2);
  }

  return p;
} /* end of func */

void *my_realloc(void *ptr, size_t size)
{
  ptr = realloc(ptr, size);
  if (ptr == NULL && size != 0) {
    fprintf(stderr, "realloc failed; fatal, aborted\n");
    exit(2);
  }

  return ptr;
} /* end of func */

