/*
  only_ifilter.c -- input filter: masking unwanted characters

    Copyright (C) 1999,2000 Naohisa Goto <ngoto@gen-info.osaka-u.ac.jp>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* only_ifilter.c */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <unistd.h>
#include <stddef.h>
#include "my_malloc.h"
#include "ifilter.h"
#include "only_ifilter.h"

#define CHARSETSIZE 256
#define RESTRICT_DEFAULT "ACGTUacgtu"

/* string length NOT include last '\0' */
static void restrict_ifilter_help(const uchar *name, FILE *fpo);
static void *restrict_ifilter_open(uchar *optarg, uchar **optstr_new);
static void restrict_ifilter_close(void *settings);
static int restrict_ifilter_main(uchar *str_in, int len_in, void *settings);

/* global variables */
const struct ifilter_details only_ifilter_details = {
  restrict_ifilter_open,
  restrict_ifilter_close,
  restrict_ifilter_main,
  restrict_ifilter_help
};

static void restrict_ifilter_help(const uchar *name, FILE *fpo)
{
  fprintf(fpo, "    only: restricts to specifyed characters\n");
  fprintf(fpo, "        only[=characters]]\n"
	       "            characters   mask characters\n"
	       "        default options: " RESTRICT_DEFAULT
	       " (only=" RESTRICT_DEFAULT ")\n"
	);
  return;
} /* end of func */

static void *restrict_ifilter_open(uchar *optarg, uchar **optstr_new)
{
  const uchar *rstr = RESTRICT_DEFAULT;
  int *t;
  int i, c;
  uchar *s;
  int slen;

  if (optarg[0] != '\0') {
    rstr = optarg;
  } /* if */

  t = my_malloc(CHARSETSIZE * sizeof(int));
  for (i = 0; i < CHARSETSIZE; i++) {
    t[i] = '\0';
  }
  for (i = 0; (c = rstr[i]) != '\0'; i++) {
    if (c >= CHARSETSIZE) {
      fprintf(stderr, "restrict ifilter: internal error: cannot make table\n");
      abort();
    }
    t[c] = c;
  }

  slen = strlen(rstr) + 1;
  s = my_malloc(slen);
  strncpy(s, rstr, slen);
  *optstr_new = s;

  return (void *)t;
} /* end of func */

static void restrict_ifilter_close(void *settings)
{
  my_free(settings);
  return;
} /* end of func */

static int restrict_ifilter_main(uchar *str_in, int len_in, void *settings)
{
  int i;
  int c;
  int *t;

  t = (int *)settings;
  for (i = 0; i < len_in; i++, str_in++) {
    c = *str_in;
    *str_in = t[c];
  } /* for */

  return 0;
} /* end of func */

